//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

import wesual.data.Core 1.0

BaseStringEditor {

    property string language

    readonly property LangString translation :
        document ? document.langStrings[property] : null

    text : (translation && translation.items[language]) ?
               translation.items[language] : ""

    onEditingFinished : {
        if (translation) {
            translation.beginRecordChanges();
            translation.setText(text, language);
            translation.endRecordChanges();
        }
    }
}
